
#ifndef _1_CRYS_ATP_TST_DH_Acceptance_h_H
#define _1_CRYS_ATP_TST_DH_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#if TST_USE_DH_DATA/*In case no test vectors are selected - code disabled*/
#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Feb 20 12:10:45 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_DH_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines ***********/
/******** Enums ***********/
/******** Typedefs  ***********/
/******** Structs  **********/
typedef struct SEP_DH_TestDataStructPKCS3{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t		 				TST_Generator[TST_MAX_DH_KEY_SIZE];
	DxUint16_t		 			TST_GeneratorSize;	
	DxUint8_t 					TST_Prime[TST_MAX_DH_KEY_SIZE];
	DxUint16_t 					TST_PrimeSize;
	DxUint16_t 					TST_L; 
} SEP_DH_TestDataStructPKCS3;

typedef struct SEP_DH_TestDataStructANSI942{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t		 			TST_Generator[CRYS_DH_MAX_MOD_SIZE_IN_BYTES];
	DxUint32_t		 			TST_GeneratorSize;	
	DxUint8_t 					TST_Prime[CRYS_DH_MAX_MOD_SIZE_IN_BYTES];
	DxUint32_t 					TST_PrimeSize;
	DxUint8_t 					TST_Q[CRYS_DH_MAX_MOD_SIZE_IN_BYTES];
	DxUint32_t 					TST_QSize; 
	DxUint8_t 					TST_FactorJ[CRYS_DH_MAX_MOD_SIZE_IN_BYTES];
	DxUint32_t 					TST_FactorJSize; 
	DxUint8_t 					TST_Seed[CRYS_DH_MAX_MOD_SIZE_IN_BYTES];
	DxUint32_t                  TST_SeedSize;
	CRYS_DH_HASH_OpMode_t 		TST_hashFunc;
	CRYS_DH_DerivationFunc_Mode TST_DerFunc_mode;
	DxUint16_t				    TST_KeyLenInBits;	
} SEP_DH_TestDataStructANSI942;
/******** Public Variables ********/
/******** Public Functions ********/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_DH_Acceptance_PKCS3        
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:  
 *  This function Is a Acceptance test for the Diffie-Hellman key agreement 
 *  scheme according to PKCS#3  
 *  Prime sizes used (in bits) - 2048                                  
 *  Generator sizes used (in bits) - 2048
 *  L sizes used - 12 
 *
 * Algorithm:       
 * 1. Call the SEPQA_DH_PKCS3 function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/
CRYSError_t CRYS_Ext_ATP_DH_Acceptance_PKCS3(void);

/***************************
* Function Name:                                                           
* 	CRYS_Ext_ATP_DH_Acceptance_ANSI942 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CRYSError_t - Function error return		    					  		
*
* Description:	
*  This function Is a Acceptance test for Diffie-Hellman key agreement 
*  schemes according to ANSI9.42   
*  Prime sizes used (in bits) - 2048									
*  Generator sizes used (in bits) - 2048
*  Q sizes used (in bits) - 160
*  Derived Key sizes (in bits) - 256
*
* Algorithm:       
* 1. Call the SEPQA_DH_ANSI942 function to execute test
* 2. Verify function succeded according to the returned error code
*
**************************/
CRYSError_t CRYS_Ext_ATP_DH_Acceptance_ANSI942(void);

#ifdef __cplusplus
}
#endif

#endif

#endif


